/*!
* MindPlus
* DFRobot, 行空板 K10
*/
#include <DFRobot_Iot.h>
#include "unihiker_k10.h"
#include <DFRobot_HX711_I2C.h>
#include "DFRobot_HuskylensV2.h"
#include <DFRobot_SpeechSynthesis_M.h>
#include <HTTPClient.h>
#include <ArduinoJson.h>
#include "asr.h"

// 动态变量
String         mind_s_total_food, mind_s_food_hot_aaa, mind_s_food_kind, mind_s_food_hot,
mind_s_deepseek_answer;
volatile float mind_n_j, mind_n_aaa, mind_n_weight;

// 创建对象
UNIHIKER_K10 k10;
ASR asr;
uint8_t screen_dir=2;
DFRobot_Iot myIot;
DFRobot_SpeechSynthesis_I2C sstts;
HuskylensV2 huskylens;
DFRobot_HX711_I2C hx711(&Wire ,0x64);

String       model="deepseek-ai/DeepSeek-V2.5";//默认调用deepseekv3.2
String       api_key="";  //这里填入你在硅基流动上获取的api key
String       apiUrl="https://api.siliconflow.cn";
String       bot_prompt="你是一个营养搭配师，回答简短,你只需要每行回答一种食物和重量，回答完一种食物之后换行";//这里填入你的提示词

String       sendMessage(String userMessage) {//这里传入你的问题，返回字符串
	HTTPClient http;
	DynamicJsonBuffer jsonBuffer;
	
	http.begin(apiUrl+"/v1/chat/completions");
	http.addHeader("Content-Type", "application/json");
	http.addHeader("Authorization", "Bearer " + api_key);
	
	JsonObject& root = jsonBuffer.createObject();
	root["model"] = model;
	root["stream"] = false;
	
	JsonArray& messages = root.createNestedArray("messages");
	
	JsonObject& systemMessage = messages.createNestedObject();
	systemMessage["role"] = "system";
	systemMessage["content"] = bot_prompt;
	
	JsonObject& userMsg = messages.createNestedObject();
	userMsg["role"] = "user";
	userMsg["content"] = userMessage;
	
	String jsonString;
	root.printTo(jsonString);
	
	Serial.println(jsonString);
	
	
	http.POST(jsonString);
	String response = http.getString();	
	String status_code = http.getLine();
	Serial.println(status_code);
	Serial.println(response);
	Serial.println("输出完成");
	
	while (response == "") {
		http.POST(jsonString);
		response = http.getString();
		//delay(5000);
	}
	
	
	Serial.println(response);
	
	JsonObject& responseRoot = jsonBuffer.parseObject(response);
	if (responseRoot.success()) {
		String ai_response=responseRoot["choices"][0]["message"]["content"];
		return ai_response;
	} else {
		return "";
	}
}
void shibie(){
	k10.canvas->canvasClear(7);
	k10.canvas->canvasClear(9);
	k10.canvas->canvasClear(11);
	for (int index = 0; index < 3; index++) {
		huskylens.getResult((eAlgorithm_t)128);
	}
	if (huskylens.available((eAlgorithm_t)128)) {
		String Name_get = RET_ITEM_STR(huskylens.getCachedResultByIndex((eAlgorithm_t)128, 1-1), Result, name);
		if (Name_get == "pingguo") {
			mind_n_aaa = 2.4;
			Name_get = "苹果";
		}
		else if (Name_get == "niupai") {		
			mind_n_aaa = 5.3;
			Name_get = "牛排";
		}
		else if (Name_get == "mianbao") {
			mind_n_aaa = 13;
			Name_get = "面包";
		}
		else if (Name_get == "miantiao") {
			mind_n_aaa = 12;
			Name_get = "面条";
		}
		else if (Name_get == "paigu") {
			mind_n_aaa = 15;
			Name_get = "排骨";
		}
		mind_n_weight = (hx711.readWeight());
		mind_s_food_hot_aaa = (String((mind_n_aaa * mind_n_weight)) + String("KJ"));
		mind_s_food_kind = (String("食物:") + String(Name_get));
		mind_s_food_hot = (String("热量:") + String(mind_s_food_hot_aaa));
		k10.canvas->canvasText(mind_s_food_kind, 7, 0xFF0000);
		k10.canvas->canvasText(mind_s_food_hot, 9, 0xFF0000);
		k10.canvas->canvasText(mind_n_weight, 11, 0x0000FF);
		k10.canvas->updateCanvas();
		mind_s_food_hot_aaa = (String((mind_n_aaa * mind_n_weight)) + String("千焦"));
		mind_s_total_food = (String(mind_s_total_food) + String((String("  ") + String((String(Name_get) + String((String("   ") + String(mind_n_weight))))))));
		sstts.speak(Name_get);
		sstts.speak(mind_s_food_hot_aaa);
		Serial.println(mind_s_total_food);
	}
	else {
		k10.canvas->canvasText("未识别到食物，请重试", 7, 0xFF0000);
		k10.canvas->updateCanvas();
	}
}

void tuijian(){
	if ((mind_n_j==0)) {
		mind_n_j = 1;
		k10.canvas->canvasClear(1);
		k10.canvas->canvasClear(3);
		k10.canvas->canvasClear(5);
		k10.canvas->canvasClear(7);
		k10.canvas->canvasClear(9);
		k10.canvas->canvasClear(11);
		k10.canvas->canvasText("deepseek回答中", 1, 0x0000FF);
		k10.canvas->updateCanvas();
		mind_s_total_food = (String(mind_s_total_food) + String("，我给你的数据前面是我吃的食物，后面是摄入的重量，每两个数据为一组，请你帮我以健康生活的角度推荐我今天还要吃什么"));
		mind_s_deepseek_answer = sendMessage(mind_s_total_food);
		Serial.println(mind_s_deepseek_answer);
		//k10.canvas->canvasText(mind_s_deepseek_answer, 0, 30, 0x0000FF, k10.canvas->eCNAndENFont24, 12, false);
		k10.canvas->canvasText(mind_s_deepseek_answer, 2, 0x0000FF);
		k10.canvas->updateCanvas();
	}
	else {
		mind_n_j = 0;
		k10.canvas->canvasClear();
		k10.canvas->canvasText("基于YOLO的热量秤", 1, 0x330033);
		k10.canvas->canvasText("按a开始检测", 3, 0x330033);
		k10.canvas->canvasText("按b显示推荐食物", 5, 0x330033);
		k10.canvas->updateCanvas();
	}
}



// 主程序开始
void setup() {
	k10.begin();
	Serial.begin(9600);
	asr.asrInit(ONCE, CN_MODE, 12000);
	while(asr._asrState == 0){delay(100);}
	k10.initScreen(screen_dir);
	k10.creatCanvas();
	Wire.begin();
	while (!huskylens.begin(Wire)) {
		delay(100);
	}
	k10.buttonA->setPressedCallback(onButtonAPressed);
	k10.buttonB->setPressedCallback(onButtonBPressed);
	asr.addASRCommand(0+1, "shi bie");
	asr.addASRCommand(1+1, "tui jian");
	asr.addASRCommand(2+1, "fan hui");
	mind_s_total_food = "我今天吃了：";
	k10.canvas->canvasText("连接wifi中", 1, 0x0000FF);
	k10.canvas->updateCanvas();
	myIot.wifiConnect("myj", "myj123456");
	while (!myIot.wifiStatus()) {}
	k10.canvas->canvasText("success", 1, 0x0000FF);
	k10.canvas->updateCanvas();
	delay(2000);
	k10.canvas->canvasClear();
	k10.canvas->updateCanvas();
	sstts.begin(sstts.eV2);
	mind_n_j = 0;
	huskylens.switchAlgorithm((eAlgorithm_t)128);
	while(!hx711.begin());
	k10.setScreenBackground(0x99FFFF);
	k10.canvas->canvasText("基于YOLO的热量秤", 1, 0x330033);
	k10.canvas->canvasText("按a开始检测", 3, 0x330033);
	k10.canvas->canvasText("按b显示推荐食物", 5, 0x330033);
	k10.canvas->updateCanvas();
}
void loop() {
	if (asr.isDetectCmdID(0+1)) {
		shibie();
	}
	else if (asr.isDetectCmdID(1+1)) {
		tuijian();
	}
	else if (asr.isDetectCmdID(2+1)) {
		tuijian();
	}
}

// 事件回调函数
void onButtonAPressed() {
	k10.canvas->canvasClear(7);
	k10.canvas->canvasClear(9);
	k10.canvas->canvasClear(11);
	for (int index = 0; index < 3; index++) {
		huskylens.getResult((eAlgorithm_t)128);
	}
	if (huskylens.available((eAlgorithm_t)128)) {
		String Name_get = RET_ITEM_STR(huskylens.getCachedResultByIndex((eAlgorithm_t)128, 1-1), Result, name);
		if (Name_get == "pingguo") {
			mind_n_aaa = 2.4;
			Name_get = "苹果";
		}
		else if (Name_get == "niupai") {		
			mind_n_aaa = 5.3;
			Name_get = "牛排";
		}
		else if (Name_get == "mianbao") {
			mind_n_aaa = 13;
			Name_get = "面包";
		}
		else if (Name_get == "miantiao") {
			mind_n_aaa = 12;
			Name_get = "面条";
		}
		else if (Name_get == "paigu") {
			mind_n_aaa = 15;
			Name_get = "排骨";
		}
		mind_n_weight = (hx711.readWeight());
		mind_s_food_hot_aaa = (String((mind_n_aaa * mind_n_weight)) + String("KJ"));
		mind_s_food_kind = (String("食物:") + String(Name_get));
		mind_s_food_hot = (String("热量:") + String(mind_s_food_hot_aaa));
		k10.canvas->canvasText(mind_s_food_kind, 7, 0xFF0000);
		k10.canvas->canvasText(mind_s_food_hot, 9, 0xFF0000);
		k10.canvas->canvasText(mind_n_weight, 11, 0x0000FF);
		k10.canvas->updateCanvas();
		mind_s_food_hot_aaa = (String((mind_n_aaa * mind_n_weight)) + String("千焦"));
		mind_s_total_food = (String(mind_s_total_food) + String((String("  ") + String((String(Name_get) + String((String("   ") + String(mind_n_weight))))))));
		sstts.speak(Name_get);
		sstts.speak(mind_s_food_hot_aaa);
		Serial.println(mind_s_total_food);
	}
	else {
		k10.canvas->canvasText("未识别到食物，请重试", 7, 0xFF0000);
		k10.canvas->updateCanvas();
	}
}
void onButtonBPressed() {
	if ((mind_n_j==0)) {
		mind_n_j = 1;
		k10.canvas->canvasClear(1);
		k10.canvas->canvasClear(3);
		k10.canvas->canvasClear(5);
		k10.canvas->canvasClear(7);
		k10.canvas->canvasClear(9);
		k10.canvas->canvasClear(11);
		k10.canvas->canvasText("deepseek回答中", 1, 0x0000FF);
		k10.canvas->updateCanvas();
		mind_s_total_food = (String(mind_s_total_food) + String("，我给你的数据前面是我吃的食物，后面是摄入的重量，每两个数据为一组，请你帮我以健康生活的角度推荐我今天还要吃什么"));
		mind_s_deepseek_answer = sendMessage(mind_s_total_food);
		Serial.println(mind_s_deepseek_answer);
		//k10.canvas->canvasText(mind_s_deepseek_answer, 0, 30, 0x0000FF, k10.canvas->eCNAndENFont24, 12, false);
		k10.canvas->canvasText(mind_s_deepseek_answer, 2, 0x0000FF);
		k10.canvas->updateCanvas();
	}
	else {
		mind_n_j = 0;
		k10.canvas->canvasClear();
		k10.canvas->canvasText("基于YOLO的热量秤", 1, 0x330033);
		k10.canvas->canvasText("按a开始检测", 3, 0x330033);
		k10.canvas->canvasText("按b显示推荐食物", 5, 0x330033);
		k10.canvas->updateCanvas();
	}
}

