/*!
 * MindPlus
 * esp32s3bit
 *
 */
#include <DFRobot_Iot.h>
#include <HTTPClient.h>
#include <ArduinoJsonK10.h>
#include <unihiker_k10.h>
// 动态变量
String mind_s_JieShouHuanCun;
// 创建对象
DFRobot_Iot myIot;
 UNIHIKER_K10 k10;
const char* doubao_apiKey = "c4a347fc-b9f9-4be6-96f5-b3334abf9016";  // API密钥
const String apiUrl = "https://ark.cn-beijing.volces.com/api/v3/chat/completions";  // API地址
const String model = "ep-20250623203023-sx8w2";  // 使用的模型
const float temperature = 0.3;                   // AI创造性参数（0-1);
const String systemPrompt = "你是人工智能助手，你叫小行";

// 本地base64图片字符串 - 你可以在这里赋值你的base64图片数据
/*
String localBase64Image = "iVBORw0KGgoAAAANSUhEUgAAACoAAAAqCAIAAABKoV4MAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAA7EAAAOxAGVKw4bAAAEO0lEQVRYhe2YT0xiRxzHvwiGeeiBdzFRLzy4wHNjQA9mZS+rLzEW9kBbD25c1/TfNrbdtpvs9tBDTdq06e62VdwlZaHEdJv1sE05rNaYqOlBbEwoELPZ9SLPC9hwEA4IjwjSw2woEbvAw8Q02e+N+c38PjO/+c3M76EoFos4O6nkD40lsBHG5hZiCWSyKBahUEDDoLMNfd3ot6CzraoPhZzVxxKY8yOyDaKGUgmVCsqmF6bCEfJ5FAqQcjAbMeF4+STqxy8H4JpHawtaNVV6pjNIH2ByFEPWU8I/XoZ/FUSN5tp27TAPKQfHIEaGTrQ3ndh6spYD8K9Cw9TKBtCsgoaBfxXLgcbwsQRc8yDqf7e5RimbQNRwzSOWaAA/50drSx3rLlezCq0tmPPLxccSiGxXz7WXqFWDyHZlAGrDb4RB1PLZVESNjbAs/OYWlMpG8UolNrdk4WMJqBq4H6lUKrnBz2TrTvhKKZuQycrCn9azVOGnNrxCcTr4Cj+14TUMCkeNsgtH0DCy8J1tyOcbxefzla9fbfi+bhQKjeILBfR1y8L3WyDlGsVLOfRbZOE722A2Ip2Rz05nYDbKDT6ACQfSBziUlQGHeaQPMOGotNSM72zD5CikXN1HoHAEKYfJ0ROrrnrusiErHIPIZOuIwWEemSwcg/9Vb/2/aj2qs6x0yydxNnX+6anhZ/QV/hVenqoXkKK4O+O8n80eL9OoDAb99Y8mCSEAFhaXOjraeyxmj9fX3t5utw17vL7e3h7eZHTOugRhoMdirhvPcbrpH+5Utnu8vmAwJAgDlA2gizctLP7Om4z0ZygcSSZTvMm4t/c3w5BSe7nknPtQOOJ2ey9dstltw8dMq2t/6Dndyuoay7LJZHLkzde1Wu3C4tKTJ4ulPgzDfHz9A47TVceHwpGVlTW9nltf36BjaAsNuMfrY1k2GhUFYUDP6b69/d3+fvKYh6vjY3+FQnbbaxynS6VSM07X+JXLlI0a/1yx24bttmHnrAvABWs/AFHcdT/4SRAGunhTNCoC0Gq133z9pSju/vzwEcMQltW++85bABYWl54+fWa19nMvlk5YVlvyXOu3CyHk1s0bNB4oSwhJkmgHmqEdHe2f3brx8JdHwWAoGAwBYBjm3Dk+Ht/rsZij4i51VTceAA1dV5cJgMfrI4TQ9VHRCUmS5Jx18bzJ/eO9konulzB4MR7fY1lt3fhkKuV03t/fT14dH8tKEiBeGbv8wOP75NOb1957u3z19Hzu7ERprtFjqed02az07Pl2ILAxMvJGuefq+J2d6NTUV6U8p8GnexEKR6Zn7gEQhAGO00198Xl5ZtHTTwghhPT2Wtxur8GgP3b8qt96BoN+ZvquMHjx9p3vr73/odvt5XkTDWCPxTwzfddg0NOe64E/4/H4419/kyQpFI5Eo+IF63lq6uJNDMOUBpb0DxIM1GqJOP5QAAAAAElFTkSuQmCC";  // 在这里填入你的base64图片字符串
*/
String localBase64Image = "iVBORw0KGgoAAAANSUhEUgAAAIcAAABnCAIAAAClwcbfAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAA7EAAAOxAGVKw4bAAAgAElEQVR4nIS8ebCl2VEnlpln+ZZ731pVr9au3qo3Sd1Sqxc1IAltaADbEB4MiEUgEbbDEbax/7Bhwg7scIwNM2YkRoTNwMwQMwMDwyYQIJAEQkhC+4pa6kXqTd2trr3ecu/9tnNOZvqPc+9XrwXyfFFRcevVfd85J/f8ZZ7E+37sRyeTCRG1bZtSYonGGOecc84YAwApJWZWZUQUkZQSIhpjRCTGSOittYjIzCICAIogIohorQUAETHGFEVBRCLSDj0RIZExBhEBQFVVdTGfO+cqXxhjOKYQQn5DCAEAaPX9vIqqjn/nRa21ZVl676uq6rqubVtmNsZ47/MpYoxElJfL+897CyEYY0IIquq9z0vkdfObiUhVmRkAjDHGGGttURT5t/q+Z2Yimk6neT/MnN+fN9z3/eF9jgc5fAoAQEQiyqsjojXGpJRCCCEEay0oxcB5l/kY+SRbW1spJQAxxqhqjDG/znufz+mcY5WUEgI45/Ly+ZtRWGPIW2nb1ntvrM2L5vcgIqg65xAxpRRXnEDEvI1Mi7yTfDxjDB1ibT6Yqu7t7WUxyj9PKQ3DkFLKdMn7zCw5zJ785BXz+7MY5eUyyfJnay0RpZTm83mMMQucc25/f3+5+RiJqK7roigQcbFY5J3nLWVyZYnJBMzbGE+RZcV2XWetTSllhjdNIyKikH8n/xoAdF0XYwSQTPF8BuecoSJTlohEljJFRN77GGP+Z0qpaZos0RsbGymlEOMo45ledV0jYtM0MUZnbFVViBhCqOt63H3+ZqZdSunwMTI58smLoijLcqTRuErWcmutMSbvObMkq1Qm2aiLqmqtzVKVTwoAwzAcHByMjCzLsixLEWmaJqXkvc9fy1SOMcYY82udc5m7mSvDMIyKdZjIed2Uks3LZ15ljSYi5wrnnLGYt8XMXddlDhsDRJCtnPd+vugzgfKGsuYWRTEMAzMLQpbHfOxsGEdZrqrKe59pZ40REVbNTB3tRrZ7mVKZZPl/67pm5ry3fOCsT6PQZKLkjeVVsmJlAulqoVFjDksuEcUYR/YsLfNKTIkoUywrwTAMTdOsra1lszZa8ryBTJZxRWZm5pSScy6/fDxvXiKzHB/8ibdmExljzJwcqUAG8klG2Vx5Ah71WtSMFjNvOjOs6zrnnBKOPiYbzb7vjTFkzGhVl1QIwTlnkVQVRLMlyVwZpS8fL/8zC/K4jdHcZZ3Iqj8uGmOsqmokzWj980uyqRCRkVJZ0b/JD+VXjZZ5GIbs/LLratv27+4k/27mxDdRvyiKw/J0+LzGGKsISRgIrXfWu9IXMcZsi1XyjpbyntkeQkhJVUE1pZQ2t47lhfOvjJ+X+ofLJ0t6VsSiKJz3mUP58PkLIQQw1jmHuAwxRqUeneEos4vFYtSPvGj+layU2dZntcham7+Zv5YNbKZF27aZHDkqGXk2OrwxWMifxw/ZJKiqc64sy/wr2fGMIcPIsBijtTZvIAtujiZG553pk/dGRGbr9tsAAK0BVWY+mM0SJ+tcXVXZOg+hb9s2hUhmaViMMXVdl2XlnO+HkImVT17X9WQyKYoixphSSsJ5lzHGNAQBLcuyH4bFYhFjHB1ACKEsyxBCHwaD5AuPRAqqANO1KRkDCIBAiFmUjDEbGxtZSjKTRova9/3I47Zt+74norIsc7AUY+y6LqsFETHzaMBzFJetAjPnl4/8y6fOzI4xZi3J9moYhr7vt7a2Mhcz6ZuuHfpeRPKWVDWb66w3+RSZAYfD3fEgeN/b3goALMIpsUgmKKiWzhMgMxuioihIoek7Zi7LMkdQkVN+CzMzXLfOoz0tyzINoW3bTC9UAMIuBgbNHtgba4yBlbLXdU1Ee/v7fd9vbm46b3Z3d60vq6qSmMIwFNY7YyUxAAwxqKqiIqLNVlZBVfsw5HMCQGLOwpgp1fe9tXZ9fV1VZ7OZiEwnE1CCQ+qYw/2s9JlJfd/nUDPGuFgsptNpNoajPRhCUFUgJCLmmPW1nNQGMITQt8MoeTlAyK4ob2y0IuMGsjWyIgLZIHrvAKIwGHJkjHOkAAAqEvvBWmsABTGlJIfCs2EYEBEMjfzPdqNpmr7vgaUoCm+diLCIs76uKl4FqYSoIiiKqqC6f23XFn46mThr27Y1AYuq2p/NkzAqkMJofEcJEJDRyoGoquagKMesOdTOlpOZ19bWEHE+n4tIURQA0DTNcuuIiZlTAsSyKCbTaQwBica0aAghx+7ZaY3WZsxLFHNQajJ9U0oDM4dY1/W4Z1Xtui77xWxpR085mussARYRdRVijp4HWLquIwVLxhCJ6jAM+TspJQPgnHOGRj82BkiHAxVVJcSyLL112W4YJDJGUERZVSHJcl0AYyx5AJVuPuv73jlX+IpVjx05qghxCCSKiJwYAIqimDcLRQBQYwwZMkRZV5BsQlZVJCIwoICqBMZYG4cEAAQGAEMfjTGFr5jZOOuMLQglcRImwMiJRVIYQFQRkAgIvfX1ZNJ3XVapnAsjkUU0xnRdx5qMMcZZVeaQstGbz+dZWbPNHOOurI6ZK2OOmQ2gc86OIX/+EIWttSASUzIK5AlVOSVS8N4bhOzTxuBv6SHxmxmT1RZYxshyKekD51BBRLL4L6P7fiAiaw0pqPPee0Ls2s4qMiiHaI1RkGEYJDEQIiIgrMIeRCIEQIB+CNmvZtcyBjlZgPKxs0fJQTOrDMPQa++cK4rCW9P3fdd0VVVlwmWFU1U0ZL3DlXSOxmcMpbLpcyKAkpidtYX3yjBuBlb5dfZwh2PLMdbNrzU7d780/zchAuKibYjIkjHGeGuttaAaQvCFt/46t1U1xTj0gy+84FI5yBjn/Rj8eO9ZpO07YSZjCAkAhPm6dEhWLEEE793Bwb6IbG5u+rLo+14lTSbTy1evSmJHZlJWVVWBqIggUXZvaCmTR0RSHGJMqkuDxswszCL5333fr6+ve++7rlORjfV179x8sagn9ZBi23chRgXIKILznqxRACRyhUdDMaUhBk4pxYRIzMIiiJQRChGp62p01wCooqCASJPJJDuVrusyYpLtfPYrI2zhnBuDtBCCOXHP3aO6iGrhPRmjIsysAIbIWVcURd/3Yx4zMpmIhECzZT9kBrOG5jWGYTBEzjlCyroP4zeJgFBRBbSa1ApgnAXEYRhYxVgDoIUv6qq2ZBCABEBUAbzzCiqqogIAuIwXRBSKosyUymmH9x5Uc76SfakxxlmbdyjMzntjbeUL6xwpcPZzRJo4MRtANGQAWUQTqyoZY+g6IpA9tvc+pSVYYK21xoyePMaYY7C6rquqypZjzO3GRw9haDFGc+ruu7M4ZWpWVSWqwrxU0nwM77PDFOZR6Za7ERYEBEwqiTmtrBhm58xMRD7ntzklJAQEQCRjrCVjCYkAoWlbXxRF6dqhbfvWOqsAu3u762vr3hiJ3DVtiimlxCmxCguzsKgoABIAYea6Eolqfj9Zky0bIE4nk8VikWKc1LVzrmmaNISiLNt2IcyGkBBAJYah79qubQwhqCCoCqswgjpryNgs3oCAhMZaBUBA733bthnLWSZYq4Qxx1fOubquc7qTDV2Gd0dBV9UcRCyz5nve8kNKy3SMiJq2FYTKF3VdI0DTNLEfAODYkaNd16UY80pLK+k9m2Vkehhocs6FrkcAESmss9Z2TRtCqKrKWsu6xAKcpRFQOTg46PvlwYZhUITpdFr6otmdb29uOluAauFLRVh0bYgRnBFQQYUcyykDCzMPiX1RFN5n9EhVC+uKohi6PjszA0sojJljHHL+kTV7uT3mnI6Mh8pKYIxRwsSKSCO8loWwKApjKCeV2VIZZy0ts5wxCFzmA96Pv3g4Qc50yEkFPvi2nxhhuCFFY21Oasbc2xpjrQ1db61FBWtt4X0IQWKyZSGWhhRzKruE7mMSEcxhhqgl47032SElzpvILx+6NmdkwzBsbW+sr69ba11hi6LI++uadvfiVVLo+7Czs3Pi+Kn9+ayaTgOnIBwkKaJ1RhMPw2CQfFkIisBSUw0s9VpVUaFtWw6x9EV2eyLijDFIiNr3/TAMWUSyaI+oc/bMmTdAxtcTQcioV4wxlyTatt3c3Lx69SoQ5lDYFt4i7e/vZw+dDWbmSn5nSqmua+dcxrqyimR8LKW0TK9yeDApKwbNKbFzbjKZ1HUdhqFt20lZIWIKMaWUHXoSFZGhD8baoihHhifmoe2KoijI+sKVzhORJE5DiJHPnz9f+iJvdGNa33j7nefOnTt27Mjtt99+8uRJa0lVy0lNRG3b7l/b3b+y9+gjjzz6yONPPvnk1x597IabbzpxbOfRrz6OziYQIGRmg+itc847ZwV43jbAUpalqjRtqyxVVZXOr5U1lWCMUZYudKHvuxRC05XOZ8vuiqKw1nk3mUym0+lh85LlfZDUxdT2Xbt70Boioun6miEjzPt7e8Mw5Ow9cOrCkHXLeidpCcUunZmIXYm+vLhMkEEHYwy+6id/Iod3OUEVEVghK7qKoHMGbq2N/dD3/ZL/qmQMqySVYRiGYXBkJpPJpKqdtaHrOaY0hBhCNl+OTF1Vd91y29kzZ2655aYzZ86cPH7ixIkT07UCAWbzdmutjgp93xdVQYCSIQDAPsTZbPHFv/3bP3v/Bx7+8pfnw3Ds1AmwlhEYkJkRAFElaUohaaiqAhX6vs/7MURd13GIBMgppSEoi3Ouqipv7AOvvG/n6Pb29vbGxsbm5mZG3SeTyYgijxoTQhgin790cXd+8Nxz3/j8F7/42GOPGWeP7hxDY8p6EjghkXE2icYYgdBb18xnHFP2wRmKHqEwWdV7MrXzWktg8IG3/njGSvu+7/vel0VGewKnvu9ZpKqqqqquXrmyubnpyPR9nyNaQnTO9X0vqmaFpHKIymKRmsUCIoNqYd36dO3smRte9rKX3XHruftfce/EF94DIqjAbNY+9dQTzzzzjEh69atffcMNJ3IsNwTOgpOlxBAowLMXLv/uu//wd//g3Ts3nFYiIeyZc3rrrQOWvm8ndbG2PhGR3StXQwh1WSFis1jEftje3Dq2fWRrc/P0yVO33377bbfcur21cWRjs6pKg0ZRLWESVVbrKEUhSxYBABSAFVBBCQCgE2HWrz/37J+/730f/fgn9g72gWhj+wgYCsoxJTRGAHKsZRAMLvHHHAfzas8ZHSjLciwcZGPovcdXvOWHR+Q1m9Sma/u+R2uqqjLWxhi7MJBCWZYqEmMsnXfOGSTvnBE4ODgIXU9EnNLQ9aXzW5ubN5654dxNt9zzspfdfONNRza36sobBBTo5v1zX3/2c5/7zMMPP3zp4sW2bQ8O9q5du3bq1Imf/umfftN3vTFnbdbnGkny3l66vFtO6qIsg8Cs7X793/3Gb7/793ZOn0bno0Iu8dZl6YyV1DeLg76bq6o3dhgGYb7h1Onbbj334P0PHD927NiRo9OqLotiMpl471ChIAAASRAlls4xgERBi2lIYMCiZWAUFBRHDgyIwrxtnfNlYQfWp5597v1/9Zfv/8AH9pumnE5MUbJKVCVrWJWZ67IgWAJFGQTKLjPbq4x4AkBOPHJ1rigKW5bliCcWRdE0jbI4YzXXbdISgqyLMqWUIdj8y02zEOY0b+MQqqo6cWzn2NGjRza3brzh7I03nH31Q99WeesNxB72d/ee/spjX3v8q899/dmnnnhCRFIKAHBkffPuO19y9Oh2WZZl5V913/2TukyBhSOSB0IjAALe0EZdJoHzFy+cuuHkm9/0ho996hMvXLlWbazV0zUsijgMB3v7wIIgQ3twZHv95rM3njlzZlpPtjY2X3rXXS97yUtjP1RlWRgkABUQAQ6inHpRMsAxASGQRVCJQRPUVQkIHIWQyCAag5qVe7ZW1tbYdtEzwF233Li1+YPnbrn1Hf/8XWkIRVFV9aQZBlYpnGMiSdyHkKOh7MJHR5LDvBEdyK4lGzT89p96+1jMIKKubau6Lssycpq3TUypLMtyUmdYjRSqsvTGHhwczA9mngz08c5ztz30wIMvf/nLbzh9ZmNtvS6tNyAR/vQP3/ve9/zxc19/FhIbpI3p2tbRI//ge958ZOfYmTNnTpw4sTGdOIcgwAxD6KqqCinXkWwURkRLBiQtFgsFAuuEqJoWjcD7P/SRn/25/326uT5Z2xDQZt6KyNGt7eNHj3zvm157x7mbb7nllqIoULWw1gEIQAqchpBCJABnrDPWe289gAIgpD4GTqXzSggsxlsOKQoDC4NaJCVEUREprUshuqoEwmsHs0GSqyow9hd/+Zc/8elPXVssto4eGZiHFF1RMsfJpM7x2xh9rfL/pWsZa6b5yd7EzmazMR4IIW5tH4kxtm2LhqbTGghjjO18UZUliqYQ+9li3g9x6E8dPXrbzbd+33d9920333L69HGDECMYBGDomuCNvfTCN/q2efVDr3rFPS/fmK6dPn367nteSgXKEgIARAAFBUCEAn0GgL23YDG1CRGNRU5purnZLXpBWJsU8y4Y61/94ENnj58kX4GhEPr10p89c+YN3/nG13z7g6d3tg2KQUMEICBJRBFB17zp2ApQWXhrUJJyTJEhxqEsS2NMZQxaAtYoQkmyDSRvAEBzYmEREbkbVJWHkFgt4PrGFhXUM/zUT7z18pUr177wOUM0LUsv7FwxxNB1nbUmew5YgbZ932fnn7mSYcPMj9xphPf/+I+pQs6A2rbPzg0tKjGi5uh7vjvbWt/qZs3JI8euXbokMXzff/K9P/qWH9xc35gYowKqYLKBFgAARxAHXsGGsGzfUABdljMOIw1L+AhQlt+7DskAAAoOQ0Qk750SswoQJrU/849+/gtffLjpu5Onjr79p370u9/8BklaevIAqgACCqKCgAJKhIpIqqKKBvT6nhQ051bjcqteE1k2COTq57LwTgpEJh8kb14RGDQRtCk8d/HC//xzP/fsC+dP33xzF2OMPFmbDkMnwiM+C4eqq9ZaxCX8vNKKgAiTycQuaxMiiMZ7P5s3xqB3HoliHLquKVw5qevQdBvV5Oo3Lsz29t7+1h9/21t/ZH1S9V2DrsJsIgUBADOVlazBzIcR91oGf3KdJYcfOdR68yKuWLJsQQ0SIIBAAjVGYXu6vnvx6stf+fIffss/fN1rHnAg1pvQBbFmuYQqLZEhQUCEJVSdP2ayiojS37/ut9gkpSQAQACoSgqK+f1QOL+xsX77reeev3CxaRqwVhHatjXmem9Yjqey/8hlYyIzsiT/V1mWqmr7vicyGYEhos2NtSEERCRjREzGZ5SlLsq2afb397/7TW9685vetDGpFm1fuSIXK0cRo+u9GjSK2FhUAABjrrdvHf5wGLV88ZNPr6KooJh7AQDW16fD0L3mNd/xutd9x9oE9g4ONjc2GDSXyJabyan96o/qkh15ZVUV0FGTv1kalnK9/ObqJwgEqID55QpEAmiUAC1trK3fe++9H/nUp9q2nWxsWGv6YYDARMvywQhKEtHa2lpKCWDZZ5KzSyJqmoaZ7cbGBiJloIaIqqpijqJCYJyxCmwQFcEbe21v/6Ybb/zp/+6/39leG3qRmNQ64WRWnIDDSgp4mPSw0lzVF/Fj+RkR9e/XoSTMKqQkCoBMiGQMMixm+zecOfU9/+DNaxOYzXNLW665ZvBzuXpGHFZsePGih/pyvjVXvmlXYgwBAAKgAqgiEgDQqpZx6623FqULqmQJiAwjgR0hNV5hvog4mUxUlVlGOc5lXEQgIuu9F9ERhuuaxTAMxhlSYmYkddZ6W0DUuqq+641vOrq1ZgkE6cr5K+duu3ngKOb6q0cNBVjWpbNpzkvIqrHq8JkREVY/+XuoA4IGQABIEZBMXgiGvn3owftuPD3tWkDEuq5jjEXhkWXUlZEBY9FlXH3FNfxWOpqtzbfiWVY7FBFQUWUCJMcx1lXlnANAIkrCztn16Zpoyj1vKcoIsTRN03WdqjInY2zGMb33ReFjjHY+n6susbNMR0MIyhIBQS0SKoQwtHuL9WryXW9448Fee2Sj/oPf/cPPfvpTv/jP/ulhuRupbIyRtOwQgJUyrAyrjOY1f/gWUrl8jDOIACbXmwmAlCEM4dSJk3fe+ZIUwBJUdakAcWWaXky+5WsPC0TGkv5/Fv2PMokUQBRUURVAlRUEhLXvW2Ym50VTCNF73w/t9SofYMZwiSiE4L1fxRTLwo+uelFs3mhReGOsMcYQKkiSyCIKguiYuWuaixcunL775adPHa8MQITf+Lf/bnN9o100RbXsbMsl2pUsoBAu28D1OqmICODvFnyu//13HgFVFRbOpFE0wEFD0585ceLBe+/1BEFgvteUtXfWDkPv0MJKCJZ+KJPVkK68iiIAZjOrf7+GHmLqNxnhFzPeICiCEkFK4p2bH8yGtvFTJChUEqKbzWaw6s/LCHXmUK7IjRqctbbvu7zzZQciM4cQmVPlPFpTON+HoQ/RkrHOF9bVZXnrzbfM9mbF9vre5X2O/LP/089sb07nbbtqebne44xox1ryWEXIzzeZ8lEAv4WJx6EPLKsOcXKIwFHCkNbqyfq21wG++uhjjz/xyEOv/vYzZ0+hMcrLF44rrv6ZJfu681tS+Vt4+xdt4pA2aw7wZOlXYBXTM7OvXdd1wzCYqnI5uCLKvSyjh8u97bmck9NEXfUCZnws84/yj8qyLAq/akZtmqYhImeLGJkDO1cg4mw2m67VpYOnn3oKADY2tlQgRc59bH3fjyW2HFGMJKBDbY9x9azQBFz6YxxJAEjLSFZEDGJdVs65ejJp+z5F8b64cuXaMHQAkCI/8+RTP/+Pf6GbNykmVDpkKq/LBACoAiIQYe7hWX2+fluDDz1yqBk1pYS4bDA3xnRdg8Ippa5tU0iABIApsnMuJvjoRz82DHEymYgIgc7nB7kBLJuQ/AFQitJZa4dhyDc6RCS7GURs23YYBltVVe55zeUBQbHW+rKoqioxC7MDItG1tbWyKBBxGGCxmDezZu/avvDpDKNNp7VzddcNqlqWfhhiBhhQv9l2Hw7A4JAfzrHNknzjlwUJSRMDyMULF46fOC0M+/vd+YsXiEg6cMaoyOkTpw1YZ+wQw/jmkdUj3XOUPupr5pklMypr/uayRpvD4OwscWmCkGBSVtkPOOcAoZu3CXVta5IQ/sO73/PwV758+vRpa+2iadY3NmbNInfG5gRjaZ1ylIxLODi/ORf6ACDfWSBEHIZhNpu1bauqrBI5tU2/tz/b3d0/2J/PmkXTNIvF7NKlCzEOxkAGPp955hkC8N5Np7UqiEBZFgAwDLEo3OhAXqQIKwubT54tJy+7XlSuP3ooZqMQkjFuc2srJgULl65e+5V/+a/QWwEGgvl8TmSHISKAMx4VUIGyvmX4nUVZJDHHlELkmCRx/omk6/ciDstKTjS/hR3Dtu2ZJcY0229cVa9tTfbm8Y///K/+zW/++8eeeLKarA3D0HVdWflcaoRDjUXZnRARGbCOxjr/2DCW70bRbDY7ODjI7cnZCOY+BMiG0VpjnADUdX3+/Pm+762FbLK+8IUvpAQpMQB0Xd/3fc7wUkqqORRe2pDDz2imRmkdA9bD1Bk/5KIpi7iy3msbBvjgRz/2wQ9/NKrYyrDA1Su7e3v783mjCcwhOTikIrKs6b04fzr8tfHLK7uXQ4FVPD1ySJe3diInVplsTtDD5b3uwrUr/+LX/9Xla1e3jh1NIEOKZEyMkSUyL7s4c/Q1+pLRpo2djlkvZ7NZCMEys3VkrbXWKHCfi0hVaZ2XQhHVqCaRyWTy/FNPnT//jdPHtqfT6c7OzmOPfvX5Fy6dOLPV98se6hgZACaTqu+Dt9dbs7/pb1yljKMx+buufoxEOamriq6ZtW23trH16FPnf+cP33PjuduaIYCFoHx5dzeyNoseCbohAkJG0jIui4dg8zGgGplhjMEVTnQ4oVntc7zOASueQTv0xphqWvQDN33wtf/cww//k196x6X9a2fPnaPSt33j68owHyzmMSVjDBEgqggDLPtaxl4WBRFNqG4UiJzq09raWvZI2UUXRUHOJ5amaQ7ms7btY0yRU0Yfn3/+eUK44YYbbr/rzq89+cS73vWuvb2DsvR1XcnqvoEqWGuzD6dDzwgHjXSnZY+aIYPy9z1JxXrXtoMirm9s9An+7W/9zguXLtWbm9cWB12EBNgNvS+q555/YQiAh8oVsrxVg8aQtQZeHHod9nYjS0bNPuz2v+nzZFom5pigKM0zz3/j//zFd/zCO//Zpf1rWzs76mwT+j6x8QU6E2LMbe8iki+75CenhmOTxqgxmf6TycRaa8684hXMy9ZNY0xRVGQNIEbWENlaYw1pimtVVXpXFcXdL3v5se21djF89bEn/upDf3nk2OaJU8dz/+eqd0SNMfSisOr6c9g6HfY42RK+mFiqioV386alwlxbzP/gPX/2R3/6vq0jx+bz+XRavvLee6uq/NLDX3788aeGEG+/87adE0dExAAQ4uhasrlEUVBdpn6rHDKvd9iEHtaVseVl7HZExL39+WQyjUne+4G/eMe73vWpz39hfXv7xNkzA8BBO58PbQIFVBZWZV94Z914ERBxmWjnSHVsFTPGjmKUWwzN5rlzMYXcFjyfz/f2D2JkXxRlUXpnnXOS0mIxi8MgzE989Wu333rr7eduufXmc0e3jzz77DMf+Mv3b29v33Dm7MbGuizvefr5fOG8V1hh3i/2nKqsKqpySHavN2PSiyJlBCCyvgnDb//e7//Kv/431frG5vaRtfWN55575vWvf/2JnfXz53c/8uGPXr506fY7zt115+2EhGZZvZEM6isrKDmTwUkCotxvlH06fvNDRGgIljfBCACdd2QRwZClpObPP/jBd/2/v/KeP3vvftOuH90WZy7v71JhybtqUqtq5AiKwowIRVmG2LOIs9Zag0g5DEMFUSGiwle53VlBjbXCbK01t5UzNp0AACAASURBVL7qVUVR9v0QY5rU08KXqppCUBUVDsNAlra3j9TTSeH9Vx55dDab/+f/2fcNbXjFPbc9cN+Dz3zj2V/91V/78pcffuMb3ri9tUlI/TAgKlkaQk8GyWBKbIjIYBqi9ZY5pBSNIePM0uAqoEEkJGOGEJq2RaKi9DmO++P3/sW/+Je//tef+JSfbmwfOxaEhzRcuHz58sXLr33t626+6dxnP/mZoWufePyrJ0+ePnvTWecMoGm7RhGL0gvwEAdRZuVc8EksqkqZMwaVU0wRQI2zZFAVEwsZ2w7ROEvehAQDw1e/9vR/ePcf/V/vfOd7P/jB5y5emB47snFipxduY+/qIkqyPteAW0Nma31jOllj5oPFARD4wnvvsgFR5hiCo9wrVYpCSCkyw/JyhHZtZ8684uWwqlxmx4uASGSIgHLYjoAwmx0Y5286e1M7b9YnGy+54/bQ89GjR195/wPVpDp2bOeVr7h3MpmqirGmqkoFEIB8lwAVAIE0y6Zm4FIBOEoSEQUWcM72QwyRjXX1pHLO7u7Onnji6f/t//iFv/6bj10+OGBjXV37tQla68oi9MNsf/a6V7/+6HZ98vjpP/6jdz/7zNcR5L4HXonGOL+8/caYCFBQvLPGkDUWEFIUZkZFVSDSXAARwBhTiAKIZE0/BOu9IDR9evaFC3/25+//lV/7td/6/d87evLkkZPHN44dGVLqOFbTia2Lbuh9VQIAgHjvC+tEJIbAwq5wZI2K5jsvwgyKBtAYi5QvCWNuFEc0RKgihsicuuceXTXFXA9RAFhYdEW+lJS1bVpP7sqly5fOX3zgvge3N9dYdOfE+r33PnD33XffcPakIRQRBWiaRVGWueyFiASkqsAAgENIZLxzjqxFsMZZay2QiQmQDJC5dHn305/94p+/74N/+Kfv/dP3fWB3dhBQp9tbVBctpz6Fpu/jELa3Ni+fvzCt6gfvvfvU8ZPr07X5wf773v++q9eu3HnnHceOHsktPJYQRA0hAsQYQ4jCTELeOuMMIQpAjCklNsZ5b6wzrNiHJIiB5eFHHvmjP3nvb/72b7/nT/6k6brvfNMbrx4cJABmYdWkHIUTMyA67/q+ZxbvC4OmbbsYBmPckCKDrmIOa8gSWiAKcRmSZDqzSDb0hsg7b3NIkDOVsQFZRFKMQIje5WYXVSmrqpzUx06eePxrX/vN3/6tH/mBH7zrjhsuXpnv7KyVZRmjpBi6rqmnk/X1dc7YsAiILCPCpECmLIrE0PWQEoeQIvN8Pr905XLTNM88+9wTTz359NNPX7hwIaRIZPsQbjx3iwzdQNrFGJUtWVYFlT7Fg2bx0Y995Md/6AdKtD/xth+67dab1v/1pFs0pS+IsjSgJmFOREDGECASElprLBKBQkiSOAKiMU4REgALDKwJ8MMf/chf/tVfv+8D72+6/tbbzt1y5+3DEJ+/cHF9e2t/MecQy7oqimlIQxJ2xqXI1zuSAUWE8hUtNfm2E4OoGotEBkkhhCQiy4AH0RIJgEG0Oax4xVt+OGf8OcnPJSNmHkJAQ7bwgJQ5V1q3Vk1oSPNre9jHB19539ve+tYbTp3c3ipRoGtDVXoAFZEk0RXLS+IAYMkxM/eJFa5dnT/19LNfe/KJF1544dreQUhxNpu9cPGCAoTEtvB1Xa96nW3PYb+dtSnUWxvoTDLGF0XXdTGEY+ub2oUXvvbkq++//2f/h//xthuPI8P8oJ3PD3aOH0UEVzpgadp5XZcZ6Egp5isozGqMK3wJRIqqiM6BAiw6fvgrj/z1Rz78xS99+fzlS0OMG5ubW0ePsUpIKSVZtA0btN6nlObtjIyZTCaB0/7+7ubmpiIQoDHGIKgq5VsWdRnSEPrIcVAGR8Y554x9EZpA10FbjmkYBpvTCFrdLMmZJxEV3iss66E5NV3M5nvXdo9tbO2cPvn8E09/7LOfbvruu9/wxqPb6/fd+0pQabu+Kj0RObS4RM2XYZYxRkn6ZnjHO/7589+4eOXKldl83oWhnk7WNjYAzfb2kcDJeseg8/k8NU1dT23lyvX1FDtflwOnru8DpzyU5Nnnn7/txhs3jm5+/uEvfPKznyLzqptPnag36s2jNQh0bW/iCmXKEXJKEgURy3piyKABFegjMOOV3WtPP/30o49/9bHHH//6889d2dvtQ1jf3krBYlm2KSyazpWFcWYW+no68XVZWIOlSylQ4SZY+LJomnlVVfkGKKoQkeSedFBBsNZ5YyG3y7AMMTjnYIXLARwKRjPufu+PvGXZSQzAzJSvzREaY0QhpCgAZM2Q4vpkupg1RzY2pQv9bOHJUEoHl69YlH/6C7/wmu/4NmRZNDOO6dixI4owtrWrorUU23T1yt5Pvv2/mc36qqqm62tdGFjEFp5VnPeXr10dYigndVlV1aT23ieUBff73cxVdZ/iEENRlrYo1+oJxji7urs1mUDfP/e1J9/8hte//cfe+sp77t6/euXk8WNoIPUREQ2BSEJE1hxjOwXYO2gvXLp84fyly9d2P/mZT1++dvX8+fO7e/sMWtZVMamtL4TQ+dJ4N8TQDME465yLzG3f5MxsOp0q8KJtnTFra2uLxcx7b8mklEAYEVEhCbchWGuLonJuNeogJmZGAuBljmKWF9ZUVQ25EILNFftRY1RVmImstZZFJQyR2SLEGMtJPZstXjh/Hlhuv/nW+bW9MPQnz5556rFHFm0bYyq93d7ebBddSomsGXEOEQUlVQ0hvPF1r79y7WB7e/uOu+7cOX68Xpv6suhDOGjmV/d2r1y9+vXnn/vKo488/41vMDN6OnPr2Z6LqixqqvsUgXAIaTE/KJxHT1SYopjedMe5j3zy4w9/5Uv/1U++/W1vecvBfFEUhXdGUkAhIgJCaxwA7B80Dz/66Ic++jef/+Lfnr94ueuHoq6A0Lty58yZajqx3kXmgeMQmQq3N5sNMaxtbSvCbLGwlmzhlZBV+xi8t9O6TinNZrP16UREJCVlZk4GKQ9gKooUkoR+aBcpT8Hx3pdlyZKEBBMf5oosm48QH3jrj5vVOAxmnk4m+UNKKeVbhYhoyHi3v7+vgtvrG55MP28I8Mj6Wn9tv5/t/aOf+dk3v+H1DpFT8NY1zXw6nQKs2kwURVSiMEu74K2tEhD6AMYCWYgCgBAYrIeo0A3Qtt3Xn3/u4x//+Gc+/7lHn/6q8W5je6te32BQBk2sTd9NJpOumTsEjKk0rjQ0393lbvjVd/7SK++5O8YUQ782qUEEiYRZ0ShhF9PP/K//y19+6KM7p077siRfLK8hKCmhIrCIIKChbhhc4Y2zSSXGyLnATOicA1gCiwQAogCiy1Lxsh9OlxgOq2JRVqooqm3bGov1dNr3/XQ67YeOiOzyrmhkZmWBJf5JdnnlIiwrE7PZLFu3PAUrbzoI901LRIA0xKBo1JKyzubz0tsEmvuPVZZzqvIQAgAAUUFVzhsFItracteuLmaLedM05y9e3N3fQ0OuKE7fcIac3Tlx/MjRtWld7Ry94xX33PFjs7d86KMfet9ffOCLf/vwrNrbPn7MFCWCTgrPcciJWdSevCuqsg/BEA2SAjNrYhFWURELkESMs2DQoHNV7SYTLHwrosMwmU6jRFE2YMhaQqPMSWRnZ6cPw6JthmFQwqoqyrImixwTLKHoBAzLkTYqDi2gorG58wNAVA0AoIC1RgSg8EA4dF3fdTHGelKp6rL0vWxwQBGp6kpV7Vg3XOI/AMZau9SeJKwZB5lOp2hNCKFbNEl0UlW2MNwHY13gdDCfgQEWLa1NIZbeI0CucassX2/QINKjj3z1Pe/5kyeeeOLozrG6Lrsw7B3sX7p8OaZh3jTWu29/zav/ix/6wdtuu02GYeLgR7//P73nzjs/9slPffozn3nsySf7lOrNdVtWxpoMmLJKF4bQD4v5ojYmqggh6RK5UcJcnU7MgDYpqLG+rou1NWAR0L3FLAPsaihyCikBijHm+W88my9Dl/nyewh9SIqSuQL5mrCACqMooMyaHpdLKaLJnwGo78PW1pYCgsHp+hqDFoWfz+cZBENRIjJImO/ugiwWC++9zT2vGdpMKeUQGQBSjCEP0XLOkGuappzUxhhbeFIoqspbq9YaFmaeNYusukQgIrgakwVLbBhVNY+RmKzX3/YdD735zW+66dYbAaDt+7IsydITTzzx5Ue+8jef+Hg3P9AQS4NkXeENA7z8jnMvue3ct99337v/+E/+5pOf6tq+KCvninnfMgoiIlBIQ4yJCi+giEjWmHQdUgQyCCQKfYxdHwYWIUPGWWt4VXFS1TQMgOKNLYoiDaHw1tlCOYYQYgy59XI2mxtCa23hrHNF6b0z1iJMj5/OnCADQBZJEfIsvXD16tWD2WL9yMa0qJ6/eL6Y1KdOnbpy5YoS2uW4AEJEEk2IecDKsg5jVqPpWDUMQ1pd2TfGKEJMYTY7YE7VdFJVJbAMoe+ahJF9VbMK5yLECL7mkk6+y7u6maeiKaUbb7zh6M5O6b3xyAk2VJwnADiy/cCrHnrgR97yQwI8nayDioRh0TERJZW1tbX7777ryMbWXbfd/sGP/s3fPvrIiZtudEDWlyklAzgpSssmDd2y4ykjTqrKAkjCbJ0BAmEYYhhi6IY+Inr1QMiQUMFbV9syDRSH0M4OKmND2y2a3RSDc25zbbq5uV2W/qabbilLvz5dO7K9eeTIsaNbmxvr63Xhs35orjITEaEiAcDu7v6HPvShv/rwR164+MJkMim9SylcOP8N6wqLlKvFqCgiwKoA6+vrRVnaPGwoT5mw3vVtp6rGWYPLOi4zJ+FjR4/KKkjgEIdhMAre0BAjEU0mE1ElROYlAL6sfo+J0qosKABlXcQhNQfBGFOUnhOEEBaL2dGjR9emk37oY98pgjdU1FXXdQW51LZJ9KZTJ3a+//u3trYip8eeepoNHjt+XBPPFs2Rra1JVe/P5swKAAQoiKhAK4g+hAjeiQgCWWuBbEwRUjIIYRgWi4Uk1sScgiYG5rood7aP3H3ujptvOnvz2RtvPHvm5M7J6bQu6woQSCGXnwHV5FI05p5jkBXYnQGnnen02A/8w9tvPffO/+eXX3j26+X6tF7fUFUkgyvyShJmJlYG9YVLKdnDYxkFlleYnTEZOWZmwDxr0w8xtH2fUiKAonSV9YV1/d7cOrd5ZDsD8PnOMSiPhY3sEJeprKHZoinKuqxsUdmMiPbD0DTNxvomEnRtn1JaW5+CajOfc4xEIPnCOKAmnpbm9a/5ztM33vSP/8n//eWvPT7zs/X19QB96lNB1jsHvCp2ESEQgUEiKzQkRna5eGWst9YiJwGovE9xiEMvImtVfXTrxM6Ro1tray9/ycvOnD552023HD+25RCUgaOIJB0SgGDGuGEpuUgQhpDPKMAKIAhACErGu43J5JX3vvzs6VOzdmYIOIW1tUk3BFHJhF91SxGRdl2XmO18Ps9XNFV1GIZ6uiarK2K5kwMNEdFisSAiS0TWOmOdcxLTwcGBSUzOr6+vEwIgxiRF5VPiDDuBAoigqIoQGUemqn3bpyGSMRRisNbW08IXFgTns8WkrKqybGYzAJhMp0CURy4RWjA2RE49VM7ccfNN/+1//V/+4i/90u5iduLY0fXJdDabLdqu7YakMoYtgKArfS3LkglAJMXIYZAQUzeQweefe9aSbm1t3XXnnQ/cd/89L3np2ZMn16q6MOQtGAAV4CAEWjlD1ucZmyCKyw5KIUBQKY0TYABgINVcWUNB6NvO1/XWdJJ9hHdl03WLfpisrzGn3M5BSNZajwYMFepjSnZzc1NWES1G3Lt2dTKZoEL2/PmynSQmpcIWmXNpSKTkjLM1uZquXbi0u7s7ojp9DM45BiEWEEVRQkPG5F2yqHMkCAJiC0tEDGCdUYEKCwABgdxPxSIGUWNEMAIoMYoAoiJjbeg1973i4K1v+flffOeTj37l9I03V9O16daRCGnWNt6ZNoa6yFMKMamQs/0QXOFJIDatdl3Y36us80QvfelL7rr9loceeuilL33p1tqaCkhST6hBIAggWUveESCoQkqCCM6RChCAJkHEGIIrHCikIakqGJLVUEeLVj01TV9MqtlsUfhKFUNkU7j9+cJ5b6zRlKuTBKo5ianr2uaGo7EbqHDeILGwrC6H5dqy9z47UoNknbHGGmMQjHJileXUYSAgQkuIqKKsakVBcv+PMoIYRLje76WrgWUMYIEoN7qvmn5yQJ1L7iCHYjllFamdvfuO29/0na/+4Mc+0XVNG8VVk7brhmHIfTQKuVceNamIVJWPDC88/+y1SxePbWy+5jWvecUr7z13yy2nj26U3td1ZRCSQBqiVSAyREhgaFlLzp2vAihkLAvHIWS3QICq3DTDZG2NnIXcg7uamiKa+iT1ev3sCxfbtk9JJmvlqc3NFy5djMqSAeZxXG/uLUEMIVhdDXXL7B0jYzw0ZnGc9zpiM8thJEQWQUSaptFlWRYNIODyatN4PYRBGUhFMiqVUZB860eXzAAiyiONVBVWQZRwJjIpoqFlM0oefHT77bd97/d+zyc++7mD/b1krBrLEtu2lZwfAygYIhTIc0whDkPouzd+52vve9VD9z/0bdYhJ1j3gKC5IIpKhXekoCxEmF36+OSooes7VM03K4FBRawrhpBiZBZARAFAshn0TSLTKe3Ouj/9s/d+44UXsHQ+1lvbmzENGxtbeQChtZYUJHGuoQwhxBhtHvwdVwOGYTVHzKzG3ebGi3F6ZQ7mli2BxjjvVHU2m60upTGiYU6WTI5MABVkvFNiCmeXiAWh5hFfedEQ882wZZXCWc2DikWQlNCa1SAhEUGRYRiKun7ZS++66yV3fOaLD0+PHiu8rcsqdD0qGLC6tKjLpsj9vfnm1tp3fNv9d9555/rmNDIMESoLPMRxcpq13niHy3sZsMJO8uzEpX3G1ZUGEO2HXlWraT3dWB9CynbC0XJdFBii7F9b/Nbv/s5v/Na/P37q5NbO0a88/tjV/b3jx3cATR7SaJFANeWOHGOyy1gmUDmFzKogK9IQLSsrshoJqKvZy5k63i1r0YvFYhlwieTvA41NRgqEmm+VLDtfjKouZxfD8p6cIQcEaMCTzTU5AGBNtAQdSAAJls1jiEgcOMW1evK617728196uPDOWjIGh74nBURgBmA2tGzR31xfUwFm3ZhMDQBHLRCsYFE4QFCRkKKqCidQUpF8NwOAQXHVvkwAWlf1Eo0fBlUtiiIlFQV0NgkMUWKM3dC3bb93bffq7rXf/IPf7WOYbm8m1HnTnD17tothcTCzRTmEAACSmFYzVjN2GWO0+cq2rsb64Gr2sB6aRZ93MGLAYzlLRNBYRGy6lgBy5YYIgbOdUVIAQGFgVEVUhBCWc5HzcDAiQAQCGPpERHm0pQIAq4CKgC8dACiDsiZeAiiEUPhqtpibqnrw/vu3t7f7rleitmm6RaesZJAjg6jaVUuR5NG0Qs6mHktHAND38WDeWEcmT0nN6qioRGNfjqoy5KmjywtQzJxdbFFXwxA//JG/fu78hd39vXnXt33XdEPXdX3fN7P57vxALDBBNZlMJpMhhkXbsOrOzs6i7SAPs89CZg0SsQoKpJRs9hxjiQVW1eKxQTZnOnlwO9H1jiYACCF4Q6radZ2uGqzy7kWE8sjHLOsIy3Io2dx1rwSqEBlyDlGXThVy4J4vlZBBBJr3MXOLIA8wQARlkNy4a5COH9u59eZbPvXFL60XPvZD17SalAzm7hBcUTbGvqjrbNdCF1MQZa28q/x6kpjyxDRAACA0xgInkNw9vXT2iqiKoCwEufOBAPDK1au/8we//6Uvf+XoiZOLfoicspEgawgwIZZr02JSiMila1dU1Xs/nUwODg58WRl/fZBsvuvTdR0qiEi+gSe5aD/OxcqNZboaEJ5HK+RAgA9N4Q8hROEk3A9D5oqMV5hX3fhZxRQQCIFAzbJZbhig69pF27SLZvj/uvqyZ8vOq7611jfs4Ux36Nu3u2W1hWWCsWJjF7ExoSAJJIEAMYSiCkh4SR7yyF+SB6qSSvKeShGGFBhsMJPjgagsK9iS1ZIstVrd7R7Ut++9555hj9+08rDO3n3hVj+oW/fsc843rPG3fr++X61WUmIAMXSKrLUmy164edNaW+ZFbo1BwYDuSAutzY3RMcHNmy98/ZVXrc6UMs6FlIDwErR+OGoA4JpOKUWAnLhtW1sYSOJVQFtDSqUELgT2bLVh5ijBI+8yLwDgmEyeE2GMkRSYLGt7F5F0XhTGTrTSeSErxiE69o5j6Lu+77W18/lcyLEvLi6Kic/zHLUKAjLWKnDqXD/NCmOMHtnKJUEhIrklwi4skevoSOgSzbk4ns2mWiwWAOBDMkR5nqfIBOi8K4uy2dTMrGxmc1N7ePr0/Mmjp3fv3v/urTfuP/h+1TQJOEUvB2IHiAVggjRYkL35HiY+PDj41Cc++Zu/8RtXFhMGpbUyGjbbxuTWu3j16JrWpu+9tfbo6IiZnYO2a/YXk82mmc/LFDkm1AxIxMKjCGBTAgYgUibTmgKDT5yY33v//Vdf+VaZ57/yy7+sjem6qDRk1obgYoxKY9u2ZTlJQD6CMmaxf5hPT8jatqqs0USqaZrIKbdZiskW1idvKcfEbd/JoM90OpWRIMk8EFEBC5ndDpoj1G4yMiP/IdswDrwKsEpO8YjDHO/BdDpNbZsShBCSsZwS7YIQBICiKGJk0ur0fPunf/VXr/ztt//v33xLKaO0Ro2kjbYqyzJT5ko7Q2CUVYYSgo/OR2bmk7Pzw739d+9+/6233/nmN7/1K5///D/7yZ+8erDwAFpn3oMxytoMgLrel8X0c5/73GSiYgRjTIxgrU2R447PMZjchsB11xpti2kGCN5D27uL7eb+wwfv3H733r17b7/1znffeO1nf/qf/8uf+7nD/WkOuVgO5/x0WkJihAAIKQIrAG1A6YiYkECriORi8MjG2qwoKOkudZFTiAESS5tLGa2MLvNJ23cSPckMspBjYUjMvPMrYwBGg5hDCKHv+9GOzefzNPzAMIaCiEWet32/IyMxO+bkXfk5BEWaOTHC2dnZX33lr7/9+q35wXFelMV0QppciG3XVM6lvkdEpTBHTQkScEgpMCDi9ODAlJPjyeL85Ml33rjlut5q/fmf/7nQp7xUdc+6RGG6jjFqreaLhRdOHmu9D8bokILAjTabxsUEgJRlCWnbxTfevPWd119/8Ojh3fv3Hp88adp2MplkWXHj5oeXm22fQtX4zGgAEN59AT4gIiBETkREWgVkF8O6qdrgOITUsgupLEskHZMPGBIwShdlKNojYkgxcEopoeA9Lv3EGPV4CeSA932fBg7gMT8Qx56GuTS5VeL85bUyUUcEQCRTwkqptm0ntowxJoZNtT07XV45vrp/9UbVuU1TB0hKqQjgmNuuOzo8YGbHUqpLEVEZpbWGCKtt9fxzH7qem6PDK4+/f/9PvvSlT7z00gs3P0QESmFK8ODRQwSlM1tvNrdu3fr4iz+AyBbVLr5XYIzebttiUra9e/zkycnp6a233r7//Yd/+9p3Tk5OEnBelvO9xeHegSQGCviirtdVnWdlabDrouoVETVNYwWPECX7hgTYe995N9MqzychQe+dJiV+wsUQwaPGzBitNQ3kkjHF3nskMkMYprUOnCTZYmYtSywWyRgzBsHjFIyc/bqucfiBQYhGdsUPKH9CSAApxAgJh1EJpYCJInPr+sneIqTokuuCiwi50VlRlIvpHjNE2VoXpU+lKFGKGEmroPjhyaPQ9R++ev255z/05ttvvff+nY/+4POdB1CwbcL7d++iVtPptFpdvPzKy//mF3+2yHIXIhB2rp8UJTCU06Ju3f/4nf/1xS9/eb2tTy+W8729+WLx3EdeBEXKaB/jarvq+35SlnuzxQcPHngGbU3Thek0b5peIWVZliStSSkhJBCIcCCtEqG2OQGzku9NLjofHSkgHqbaBheQUtJkaGBR3U2SRI6IRrLIER/GzN77+Xwu1Jiy0DAMmoiTx4HweqSuLssShmmMxACQQggxsTYmM1amprQCa3NmruoaIpK1s/29PvimbTd9LXShKaUUPAAIHj4GHzkxc5GVk8VsdbYsDJ2uzvbKEhXuHe4pDdWmy4r80aMHJycnNjc2y6az2bdf+847793+1Cc+gQnzIpN+no/MiB+cPP2Lr3zl7dvv3bh58/D6jaZrty7o1CUBn2vErMi0AaLG+eneno/88jdfefuNN/7jf/j3ZZkFl4whJuVCL3NjDNC53sdgi7z3gU0IyAHYKOVj7PpOAdvMMO8UueDytKYiMUtik4RdT26I937nReTsixwGDHoTl4eAYNDoGUf81CAPICWyuq6TTwoHNbEY1SDUFBhc8KRVQupc64JLyNrqrMxsnpvMKkORA2rQmcpyk4lQkiYytKnWm3pjcj0/2O+9v3f//md//HM/9MMfCxFQIxC8+fZbq9VKuJnmi+lyefaNb3ydmUkhAOS5ZpSSBNRtu1ytFocHs/29azc/dOX6jf3jYzbGJd62bdX1aGw+nSVS27a2ebaptq+8+up//e//7f17d0OAlFLTdDjIgCmlGKCu66bvlNZ5nmtrAJGMtlmmtNaaylm5Y2GTZVQkf1CrPvg+eBeDTzvAMY9NxRif1ZfELsnUvoAlR7c/uncY5LxwGLzsui4l6HzXtn0IIStEw0qF6JCImbXRnefVeutjyqa5sXndd/VmLdCWvLAhhNa1kaMGQuYEUVTFlFIacf/qXt+0s6xot5tM0bKqPv+LPz+b5F3nJ5MsAdy5c6dt26OiaL3PjZnt7X/v3XdRI/tUbZrpdOKdN5lpe266npWeLBZPlsus73xMRVGAxr3ZPhC64EMI27ZLLijE5XqV5/lHPvIRZEiBnXPT0rpeVgkUkVIYGLqu0/TjzwAAGoVJREFUE2EGUJBScL6LzETgXOe9n5Y5IqBWlojpWbNcTIsoTiGioV30K5Ng1tpnInviSIQAceSnttYKafXlQTTZG2EPleC4fbq8uFhnP2TZQ/QMwEoZ1/fZJG9bb0pTtU0gSD6gTmSMJQocQwgJUClVTifOufl0AgCbzcZ7L9mS73sTODc59s5dbEPb/uav/uqnP/4JxcCkQg9PlqvXX7u1t3fw5PHJ4uio2rb5ZNoH8A4ypNJmioB9AGMQsY8hIqvcHuzvAWHTd33oScP5ZotaGW0BICuNmWSx7VvXn5ycLGYzSOnBvfsv/eAPhi4SQHBRKcUxJSYXgSMkH7LcZrmufU8GITFHf7C30ICbzcZxSMzWmNxkACDyaES0N5uPmUZwvm+70SY55/TIh8DMQmysd3XoHXRP1O8EdTeaRb7Ev8IMMq6fkmh2KFAqRs/MMaTICRmqpm7bdlJMAFgCc4bkonOu8857l6y122ojXPS51opZAeRZXi+X2IfTp09LbX7pF37+137lVw8PZhrBM5KG733ve7ffv3Pzox/tLy6UUp45AW6q7dnZ8saVfWKABILrIQ0ueM8pBp+8AyWyEgkQprN8W7frqi7yiQ+OIszzsm2btm1fuHZNa71Zr0MIhTUAEFMgwoSkADMNzbZKKeVlUddbNirPbYyxrdoY/ESGuCJzjF3fd30PA9BOXSIEG/3N6CZAaD7EZIlrkUqy3JXRZFlr1+v16FfkVonpq9sKIwcOXddFoWgiJIV956Qqo0kphL7tovMaAQnarq68VxrzPJ8VeUoxRFdktqocS3E6cbVeR+8zZaCP4MJPfe7Hf+af/NQ//syPHV+9Um8ak2d5oe4/Pvu9//17QLDttleu7vfRkwWt9XK5fPDgwXNHB4gIIUrRiGh3C5VW7D2yQmSS4ktKi8VizuxcgJhEjW+z2YQQZrPZoENnBKNDGpVSHIEByMDjkydd1+3tzz3zqqqgU7PZ7ODgAAH6qr1Yr2yR2SwTZQkceZH7XjRQdnWTS10cITXUNEh6jiVh8SU8KCTIvZnP5+PlGOUtACAvMwWAiE3Xyf9NnDjKkCcqRCTFDOxDpk1pszb4wuhZlsXk+7Z1VUBkpbFp2r6tOXAyigNH35f55Mpi8bGPfPRf/NOf/rHPfM4Y0gDGgFIlKrj/8PQLX/qT19+6de356+u2tlx69oCsrd6er7//8P6P/eiPAKGPXiubEGKE0+V5jHGcyVdKI0Hn2r5uszyaPJNEARO223pWTowx2+12vV7DjheBjTWJIxJgACCICe7fv9+27SzGyFEppawFgKqqOKXC5teuXVtt11LqdYPaEQxz6+MtuUx7Jz9acsZRGmQsPo57IBswnU4vmaxn6oWcEsFOqY80cBBO5pSXBQDLMH/TheXJSbutum2dzfK6raumFfJcwMQhhuC2m81sNr1+5fj69Ws3rt14/rkbNz908+rhlU98/CXfdBq4MNB13DR9OcldgP/5u7/zla9/7ejacUC+cvXo4ZMP7KTISCtrYkqPn3wgXzj4ZPTORS+XS0RU1ihrgFCm7CdFaa1dXWzitt7b29NKhRCm02m32TZVrW6on/iJn3jxxRdTAkhpVzLfdcCgacKDRw8TQogRdzXsXdDEQ8ZdFAUDCGWLtP6E+JMGokFE1CQVaOBBE2oX6Y66POOAJAzTzZKpiBISDeJdwlhNRF3fJESIqesbRcCEzNIjpa5pNSjQplpt1ufLUHfb5Xl76kSfIDdZntv9vb2jo8P9/f3PfuYf7c8XB3v7k8lkPp3OynLH1RbB79BLqnO9zvI3373z2//lP7/73p2kYTo5vDg/u7I3mS6mF+vV5MoRdxEVnZ6e9t4bYxIwS24LsLy4YAkglYos2VwktEbp/f19KU90IWZklFJ93z99+vT5n/np3/qt3/r0p38EEUCR9x6I0UdGxQgnp08/+OADUYXVWkNwIQRtreisuN5frNd5mRtj8jzPskz8inh4Q2q0T0A8Vklk2bXklpcJk+ASlwcOyh00SHKMsfKuHKAlUoi+k2L+rj0UnOeUAAgYNNEnX/qHJit0nh9dv2pyM99bHB0dHh8fXzk8LMtcaxV6L1P6u8ZMghCT915rYzJL2jBB68Off+mP/vjPvvT6m7cOrxwdHh2drzcqs+vNZjov67ZiiDEE1Op0eV61zcQsUKsEEBlCiuv1WkALQ+s5DZlAms33iqJYrdbMrC1VXS9B5t6i+OxnP5sb4gAivxLEdCvFDA8ePXz85EkxLWVBZ7OZyWzTdU+XZxppPl9cuXq0Wl1INKuUwoFqAhFJ7bhCEBHUOFKShJVICwGSKB6MYqFj46vv+6qqmHmHBho0rMb901oZUjILKr0KRAZMKUZjjGbFvd+bzH7pF//1r89KstB7YAJUu8aldLqSZ6MMABCCNkrmxEgRmSwBxI7PL5av/u13vvLVr/2/115ru+6Hf+ST2uaragVa50XmYvfo0aNr168vz89NJMa02W7bvgNaIBEjpATex6ppvVSG+Jle62KxiNE3dQ2IBwcHWuvYOZXD43v3Y/ICzHAuFJluq4aIjNaJmQg8w8np6cV6dbw/C5zK6bSPQVQcrLWTyaTICufcbDYTFAoPI3eikslhJzsqFgzHEpnItAj1kQTRwockTbFxA6TUL4quSqkx9xlcS2rbNs/Kk5MT52JpVRQOuL6fFiWRqtabIp9Oy5IMOAeEQAjAEB24CCkF0ooII4A1QAA+gXOpbevlcnl2sXz/7t079+7fevPNB48e+5iK2fzK0ZVAtKmqyACILgat7dWja67v8zyf28mjbeVTXF5cvHD9OCtMCKAMvH3rnXv37u3v7zPhtq7kQxzuHzR1bYwpS9U7t62rzFjN6J2/evWqVPZQAyR0LhpjdGYgsus6mxtI8Np3X1dGz2azqPB8fWHLIoSQQshNBjGdry689/PJBAfFYhokKauqyrSRRpwU5tWg0SKsYDoNIq3SRTCDeLKYNalxiWKlRMyiWjsCxkPw4HyMcXl2UddtaacIpLVdzG0KLvR9lmUqM94DEYACAggBYmBlMM8hsq6bULXNw4eP2r49Pz9/+Pjx48ePn54+OTtdrrcbXWTO+xijnpSTcqKtTYBV15PWIM0e73fSVESWrE9RaV01WxeDC9y1LSbIp6X0OtEok0yWZaiorquz5bkCDCEAYuREpHwMiZEQuq5ru64PkAmPckocg1Kq7zpWBAAnp+cPHjywRe6C39Zt1VT71opQgdR2VYxd10kLURIM3MXoNK6qBFBj9f1ZviK0lOOv4kB6Q5fYPSXvkzqBeEUeuJSyrIgBMctOz8+Wy+XBfJpiBEhNW6eUMrL5bLo+r965cw+sCSkC8LapN+tt3TZ12yzXqycnJ8v1anmx7lzbdV3nnfc+pkCotDXKE2vSuSVtI0Lfu5BiCGE2nzACI6TEwXskVghENDFFOZ08PT1dbdYs0luRGeGDkyegKM9zMhka1NaCwui8ApRaujWZMHFjZK2VWO8QUp4Jc/EuJYBddwTefe/2nXt3bZ4Livrw8NCHEEKYlhNr8945Y8zzzz9/+uTJaC3H3AMGTdrdlgyiE+JEiEjLWkup0Qwy5PIJpLYoKYvgjJVSQpA0uhZmBmv0dLpcrU5OTl/88E1xLZPZAjlCwr7p/+ALf/i7f/CHTUhJZtYImCGm5FNMwEgatZot5l2MaO1sPtNaMyarjc2zRMrFIJFl33WIaLNsNpmG6HCgWkkcUkophhhjNDbP8w/qarlaIUFRWGZICLdv3w4hEOm2bUMbsqJAgizLCFAUbMhoTuC9x5iItABTmVkhoKLEDIPcXZ8CKnj//r2u76fzGWql0QpmMRGF3nFgF0NMLCEAjBnSEGgx805nS0a2YMcyLVullOC4U0qDrJHQR4ZB4GNEIYmI71gz3oXOCDEmjmGiVNt3Dx89YvhRbQxg8jHI8Lln//jk6aqt54dHxWLGEIGAmTvvut4FTtpkJrNN57wS5hlKmlxMzjmIwbuIigAT7Bi0wVjSBn1IgnhBQo0EQClpZm76rrSZkbIpQ9X1zOATPz0/U1qT1rF3LIkUqQgxBA4xpIhxKH5jTIxBGG9ijAxqBzFEZIhMSpMODA8fPZot5mS0Uiq6rm5rqbJba43JUt/5rk8+hCFYRUSZEpPVFoUKcSeSAkrZV7y7loK+VAJSSqNO+2jE5Gc2m/EA5ksjAR4CGqMF3ED6zr27bduXk0za+ACgGTdNdXJ+RsZgZproUKNwZIBCOy01QojcprA4OnTOieK05xiBffTJpxRYa22sslYzq5Ri8L3zDREJC+LY/tHaENFFUymGsiyrqiKESZExwNmq2qyrEQxXFgUZtWPCUQaUpJQMgrpitkwt7ULQWFpIkhkn4GQyQoTbd+/fvn1bZzYhirbYwcGBiNONgFOrzd7+/vn5GQ8UtepS1pFpM2aKKcSRNExSxh1jiAQAMcaiKGQ/ZJ+k9DLYCh4LxjhghTtOSAqY0Kj3793d1JUtbIgBpGBj1bZtnl6cJ6OS1hfVlnKIEIlIaauJgDAk9pzuPryHatfbzrKsKIp8kjOjbxzHBJw4JlKIBJBiilEkKMRKhxACB6t2FiBpNnn22ndff/vdd2/e+BAp+/a775xfLPvgbQwhRooxBie6S1pbUooZAidEtJk1SCrssImd61Oa6h0wd8dB1Hn/1a9/7c69u2Y2TcCdd1omKPN8s1qfn58jaZNnCLRcLi8bfDVIezIzph1saNSOSgPH3g6lNzaJx38de1+CRZIAbrwi8ugQQgJufA82U6xSSienTzvXG0JkHRmU0gnhdHl+7/HDOsV5rjRmkb21RiJFFyMHUFoVJs/L3VRG27bB+bqNwu2wP9uLEKJzqNAACYI8hJBpq5QipVNKffDBpzb0CjHP88ls1vj4F1/96mI2//jHPkbafvnP/xKsnud7B4f7664OKblul1WsNxutjYxvK0C0GZISexBjjNELAIWijhRixNaFi7r+1re/s62aw719ROy6Li+KbdUohYDq4PAoyzIXQ985VCRleNhN5T2becuN3dHYIkoGg4gS4jrn9P7+vrSEF4tF27YXFxdSqBm3Lg3KLTIDLrVksYNlkXPDhbVx2+S5PTt7ulpe9FeusgvGKgKqq05nOVrSpOzcxrN1XuR1XVdVJV4qJUgBY9IA0LUNEWXW5lp33hmjp2XhnNNWK2WbrnY+GWu10tpSYoSEzruUkjFmvphK2uuda7peFcWNj774169+64tf/xoRKZPNFvN8Um7bqmtbRpiVE0R0XZ/b0gWvSU/nU0jcNZVLYZJlV68cnZ+fK6UUQdv0lHiS51mZNwl+/4tfvvXOe9du3rRlebZZTfbm5xfL6Xzeup4BDRnfdcF5RDRGz2azPuymTYzSiBi8H5cUEqcYkwLvXEqp67oszxeLBQlBKyLWdS2yraNH2t3irpN85XJMjYPu6PGVI05Ba5rMJwnhwaOHzDxd5MvzlVIwneXvvHf7fL3qfXf/wT0mlshPygcyQc4cfddy8BADB+/apu9bDj6lEIKTKjZjksnalFLvQt95rSyCQlDAFHyq63qz2Wy3W04CayaV5fne3uL4eHF8vH98JDQwbdcJStj3LjgfpbZNxujMKGtIWS3kv/3JyQf5pAyc6rbPygy1ulitq8adb9tvvPzy6XqlrBUw+2q1MlnGzKQ0E/ok3TyWjKRpGqn80iAEnee5FEqeiYMOEYF0JJum0c456QdL4iIGDgaBKbnLgn0ZFajGMCyl9PTp073FYltf5Nb2Md363ju/8K9+dtvEvatHfQRU8Mbb3+t9eO76c6u2apquzHKJ68ZMSGwmDzyPY/g35rpjfAKXdLHGoEOm1KTdLfYELkEMxk7EqMwsv78DIyIabbUyKfr1+kIBlkVR5hmEkPb35vO5tkZnGQPY3Bi9qHv/u7//+2+89ebx8XGI8fx8fXh8telaVuS9J9GRjlF8KiCLTDsoskozRJcGGgDEnf5KYiLCIVxWSkXpck0mE8lLvPfyq3Ldxkb9+M3FZcm6SCxAIbR9c+34OExKQpUXxbvv33lwcnbzuSs+gI8QHWyber63l5fFVEHGyXe7hHa0ioICkNCcBx14KSt47wVtMxYtpC83xo1jAUI22Fqbwt8JSWCYKMuyTJ4sZ8IPVAIhsdbap9D3vUaaTadaq753WtsHjx4+OTk9vnL4+OlqktnM2NfffOOP/vgLqOjmD7zwwdOTpmluZFlIsfXOx2DIIO1AitZayYSIEBQJY9gu/5OiezmJMTIwEcFQCx5AJKR+4DOfEbskZbUxe8eB0XW8fXKuR2iLLMRsvtisNrnNoo8p8dOnp+vN5pOf/gwZuv/og7/86lf/z998Y7q/FwGqpjXGOtfvUGTDHNPYAx3BTZI5yQmQe6mGcZux2zZe+THzldgE+FnlNA1DORJAy6JIViGXLy+Kpu0Qd/QoeW6AU9s0dVXNZ7P3bt/JbPbhmy88f+OoyM3L33z1P/32bzfRl/M5auVTzIui9f1ydUFKBfmouywZjdYKMaYksHUa5twVkVXaGlPXdd/3MQzrnJK+hBlSxy+9NK6CVPVlFcZUUVaqruvRoKmBwNlay8Cu7wEheD+dTpumeff9O1VTPzk7/6M//eKf/NmfLrfrK9eO675l5h3p5lBDG2M5OfVjD/RycUHOgfihkUH7ciGOB+EBiTi982NHLg2oaPlG6dIwm5w8oVFtu14uk1bU9X2MsZxMppNJ3/dPTk6qurbF9Pb73//DL/zxy6+8cvTc9XI6PV9d+BBmewvnXWKeTKc++LGaIoMDKcYUIwP7EMaDTkRjhZiI7HBEcACr7s7Qp3791+SQSmJvBlnc8ZbImwlWXL65ZDpywBmxKArX9ZrU3nSGiU8+eIIAVVVVdb13sH9wdCURbqrtdD5DBOd2dn/0IvIuYkJ51CwfLnUYSP/lE4qVCztObRpvw2hvjdoZtNH8yvPHbRsDGfm1vCzbtpXvIg/MbTabTC/OzuezWb3ZdnWTG9u3HcR0/Ny1dddk07Kqqtb1wiMROTGhYIN2b80wfq8IPFZ7Rf5D3l0SeIU0VsDGhB0R1Yc+9am2bYXUReyDvHI06HBJBVy2VIICMQK9cxcXFykmBt5WVVmWLgad2aws5vt75XSybWofQ1mWXd/VdVMUZQh+7JvJHgsAMwx61uNdFLlXQftJ61TyJznsYxYmD9kZvfDMag05RxxrSOPtF/MgDPwSDT5j4maum6Yoisxa4Vrs+t7m2Wx/4VPKJsW63sqwiw8BCLuua/tO4J8SJdEAztZaa2vkxBhjrDZiSCV0kveSVP3vZZT4o//u347DEmPZWVZ/DITGe0OXslPYocWdtZYRnHOQdlOTsoKS1vZ9T1pNp1OjtHMuz7OqqiTwG0cyx2gCLuEC5JMYY0Zoh4wJSNo1BoTib2KMWmvp3Y1OZVxoIpoMvGfjiZbnS31PnA0MdRdE7JpWCcc17Oq9McYI0UNUWos5JaKh05zkOXJeR6Mq4ascCEkBx1hGIcn27A5338cYJ5NJ1zdEpIuikNhUIDYCDeVLHeLROIx56WgBxhBWfMyzvxrNMdosU0rZPJNTL0rfq9VKKVWWpazmaKAkJRrNyLgxYhlwkO4xxsh+jIi10dyJs5lOp4JnlEhB8AVjKCwR8+WzpZRyzgm/mbWZ7L33vshz+ZbIIIZBMTPHSW5FlTPG6GMYN0DwcvJXuYtSu9putzCAUsbjTkQIKCuAwyCqFMG0mTKz7vteTIR8DTnm6e9ODyGizK9cPmv4bG4oJmBEisA+hpQSEqEmn0LgiIiUoGmcwJHEJch9klsoFkbG+8Y0aIxuBeE5BiMw8JWOtm78ZQnWZRcv+yp5CwkcxjxmfBe5r8PhQxEwYmZUJERqhESKEDFFiAyh70MKHNMYEwlhate0o8GUm2Eya4zhuBPeubwBo4XQWscYhYCRkgJCq22MUXddJ59DTpa08eUFcAlWIeDVMUoeg7Rd9yYxapJ6XxribudcipGIUPBtgMaY+XwuB2dM8qX4I6GEGFZZJrEqeZ5LjUgqspeDQ7nBYdC/jIMuVp7nRVGIBR+t3BgyyBNGO9n3fZZlI52z955IyacazzUghhh98CEE0a/WpAajNxTqh8YHDFCV3QlOO4YCCUnEjsk4ythol1WVl3RtnVLS8p3HBGU8kpePFQA0TTNekXG3mRkh7ab5wfBAMmSNUopSxISktcbEhKyQssyGAdk0Bg5jyDuGxaPNlAMlV0qQHnIInHNiH8Zjrof5ZkEpjrdkdOzjfqdBjkbeyEjZByDFOGSmUSkVY1BKpaHjm1ICAmVUaUtEHNQPdtAvBNAoz9JEJMiFkGTMkyVEDiHg0BmRi8vMAowaj8gY9OoRzSd7WBSFeCGJDcaz+YxK8lKVLKVEaCExAwfvGSDBjjtBVoGINBJpBGaOKYTQtL2Ao2S55aaKceehdToWRcbqCw29g3SpyiJvkQYusjE4HCMc6XyHECTCvJy+jA8korZtZcuNtaOJ333NwONbSHiyix7TTlWaiMosJ6LNZkODm9xhVREAIBtoPUMINHBFy9kKIYS4m0Idk7OyyHd+Re44DF2X8WU8JHSXz9d4ynCogmhNIcUQvNCLAYD4C0REJsdxhzGIf4dBUd5o3Ps4qCiNlZLRQl7OsOSj53kehwGzy3ZAFlQMox4G1S5/Lxqq3fJAIuraOqUAkJTSRpMxKqZn84i8Y6PBhBA4UYzee44iIQJW6XGkUYKdhM8QkaSIiLTSshQjNogHsx9CiCmKQRI7ofWOlEIdfOwfBB9IK0UqcjpfLmV4XpEavSIPI8UwJGjS5CmKom4qJGSgyFGRyco8z0uldvYPEOVm7nyR1sbopm7rugYAyaRgwPb9vS2R0s7BwcH47rQbod+xAMm/yENG0zfeua7rttut3MXJZCKposTKcRAeCiEowqIo5vN5XhaE5IJ3zvsYtNKkpd1r1FCC885lxj4z4wghxr7ttk2dGZtwCFN5oECNCYliCBJ2ymeOQ/gqoZS1VgBfLILdKSLy/weqA+4AwSKIRAAAAABJRU5ErkJggg==";
String imageFormat = "bmp";   // 图片格式：jpeg, png, bmp等

String getGPTAnswer(String inputText) {
  HTTPClient http;
  http.setTimeout(20000);  // 使用配置的超时时间

  if (!http.begin(apiUrl)) {
    //Serial.println("HTTP连接初始化失败");
    return "<network_error>";
  }

  // 设置请求头
  http.addHeader("Content-Type", "application/json");
  http.addHeader("Authorization", "Bearer " + String(doubao_apiKey));

  // 构建JSON请求体（使用配置的模型和参数）
  String payload = "{";
  payload += "\"model\":\"" + model + "\",";
  payload += "\"messages\":[";
  payload += "{\"role\":\"system\",\"content\":\"" + systemPrompt + "\"},";
  payload += "{\"role\":\"user\",\"content\":\"" + inputText + "\"}";
  payload += "],";
  payload += "\"temperature\":" + String(temperature);
  payload += "}";

  // 发送POST请求
  int httpCode = http.POST(payload);
  String outputText = "<error>";

  // 处理响应
  if (httpCode == 200) {
    String response = http.getString();
    DynamicJsonDocument jsonDoc(2048);  // 使用配置的缓冲区大小
    DeserializationError error = deserializeJson(jsonDoc, response);

    if (!error) {
      outputText = jsonDoc["choices"][0]["message"]["content"].as<String>();
    } else {
      Serial.print("JSON解析错误: ");
      Serial.println(error.c_str());
    }
  } else {
    Serial.printf("HTTP错误代码: %d", httpCode);
  }

  http.end();
  return outputText;
}

/*
String getGPTAnswer_base64img(String inputText, String imageFormat, String base64Image = "") {
  WiFiClientSecure client;
  String outputText = "<error>";
  
  // 设置SSL证书验证（跳过证书验证以简化连接）
  client.setInsecure();
  
  if (!client.connect("ark.cn-beijing.volces.com", 443)) {
    Serial.println("连接服务器失败");
    return "<connection_error>";
  }
  
  // 构建请求体
  String payload = "{";
  payload += "\"model\":\"" + model + "\",";
  payload += "\"messages\":[";
  payload += "{\"role\":\"system\",\"content\":\"" + systemPrompt + "\"},";
  payload += "{";
  payload += "\"role\":\"user\",";
  payload += "\"content\":[";
  payload += "{\"type\":\"text\",\"text\":\"" + inputText + "\"},";
  payload += "{\"type\":\"image_url\",";
  payload += "\"image_url\":{\"url\":\"data:image/" + imageFormat + ";base64," + base64Image + "\"}";
  payload += "}";
  payload += "]";
  payload += "}";
  payload += "]";
  payload += ",\"temperature\":" + String(temperature);
  payload += "}";

  // 添加调试信息
  Serial.println("=== 请求调试信息 ===");
  Serial.println("图片格式: " + imageFormat);
  Serial.println("Base64长度: " + String(base64Image.length()));
  Serial.println("完整payload长度: " + String(payload.length()));
  Serial.println("==================");

  // 发送HTTP请求头
  String request = "POST /api/v3/chat/completions HTTP/1.1\r\n";
  request += "Host: ark.cn-beijing.volces.com\r\n";
  request += "Content-Type: application/json\r\n";
  request += "Authorization: Bearer " + String(doubao_apiKey) + "\r\n";
  request += "Transfer-Encoding: chunked\r\n";
  request += "Connection: close\r\n";
  request += "\r\n";
  
  Serial.println("发送HTTP请求头...");
  client.print(request);
  
  // 分块发送数据
  int chunkSize = 4096; // 4KB每块
  int totalLength = payload.length();
  int sent = 0;
  int chunkCount = 0;
  
  Serial.println("开始分块发送数据，总长度: " + String(totalLength));
  
  while (sent < totalLength) {
    int currentChunkSize = min(chunkSize, totalLength - sent);
    String chunk = payload.substring(sent, sent + currentChunkSize);
    
    // 发送块大小（十六进制）
    String chunkHeader = String(currentChunkSize, HEX) + "\r\n";
    client.print(chunkHeader);
    
    // 发送块数据
    client.print(chunk);
    client.print("\r\n");
    
    sent += currentChunkSize;
    chunkCount++;
    
    // 添加调试信息
    if (chunkCount % 5 == 0 || chunkCount == 1) {
      Serial.println("已发送 " + String(sent) + "/" + String(totalLength) + " 字节，块数: " + String(chunkCount));
    }
    
    delay(5); // 小延迟避免缓冲区溢出
  }
  
  // 发送结束块
  Serial.println("发送结束块...");
  client.print("0\r\n\r\n");
  
  // 读取响应
  String response = "";
  unsigned long timeout = millis() + 300000; // 5分钟超时
  unsigned long startTime = millis();
  
  Serial.println("开始读取响应...");
  
  while (client.connected() && millis() < timeout) {
    if (client.available()) {
      String chunk = client.readString();
      response += chunk;
      
      // 添加调试信息
      if (response.length() % 1000 == 0) {
        Serial.println("已接收响应: " + String(response.length()) + " 字符");
      }
    }
    delay(10);
  }
  
  unsigned long responseTime = millis() - startTime;
  Serial.println("响应接收完成，耗时: " + String(responseTime) + "ms，响应长度: " + String(response.length()));
  
  client.stop();
  
  // 解析响应
  if (response.length() > 0) {
    // 找到JSON开始位置（跳过HTTP头）
    int jsonStart = response.indexOf("\r\n\r\n");
    if (jsonStart > 0) {
      response = response.substring(jsonStart + 4);
    }
    
    // 打印响应前200字符用于调试
    Serial.println("响应内容前200字符: " + response.substring(0, 200));
    
    DynamicJsonDocument jsonDoc(32768);
    DeserializationError error = deserializeJson(jsonDoc, response);
    if (!error) {
      outputText = jsonDoc["choices"][0]["message"]["content"].as<String>();
      Serial.println("JSON解析成功");
    } else {
      Serial.print("JSON解析错误: ");
      Serial.println(error.c_str());
      Serial.println("完整响应: " + response);
    }
  } else {
    Serial.println("未接收到响应");
  }
  
  return outputText;
}
*/

String getGPTAnswer_base64img(String inputText, String imageFormat, String base64Image = "") {
  HTTPClient http;
  http.setTimeout(120000);  // 增加到2分钟超时时间

  if (!http.begin(apiUrl)) {
    Serial.println("HTTP连接初始化失败");
    return "<network_error>";
  }

  // 设置请求头
  http.addHeader("Content-Type", "application/json");
  http.addHeader("Authorization", "Bearer " + String(doubao_apiKey));

  // 检查图片大小
  int imageSize = base64Image.length();
  Serial.println("Base64图片大小: " + String(imageSize) + " 字符");
  
  // 如果图片太大，给出警告
  if (imageSize > 100000) {  // 约100KB的base64
    Serial.println("警告：图片较大，可能需要更长时间处理");
  }

  // 构建JSON请求体（支持图片base64）
  String payload = "{";
  payload += "\"model\":\"" + model + "\",";
  payload += "\"messages\":[";
  payload += "{\"role\":\"system\",\"content\":\"" + systemPrompt + "\"},";
  payload += "{";
  payload += "\"role\":\"user\",";
  payload += "\"content\":["; // 多模态需数组结构
  payload += "{\"type\":\"text\",\"text\":\"" + inputText + "\"},";
  payload += "{\"type\":\"image_url\",";
  payload += "\"image_url\":{\"url\":\"data:image/" + imageFormat + ";base64," + base64Image + "\"}";
  payload += "}";
  payload += "]"; // 闭合content数组
  payload += "}"; // 闭合user消息
  payload += "]"; // 闭合messages数组
  payload += ",\"temperature\":" + String(temperature);
  payload += "}";
  
  Serial.println("Payload size: " + String(payload.length()) + " 字符");
  
  // 发送POST请求
  Serial.println("正在发送请求...");
  int httpCode = http.POST(payload);
  Serial.println("HTTP响应代码: " + String(httpCode));
  
  String outputText = "<error>";

  // 处理响应
  if (httpCode == 200) {
    Serial.println("请求成功，正在解析响应...");
    String response = http.getString();
    Serial.println("响应大小: " + String(response.length()) + " 字符");
    
    // 根据响应大小动态调整JSON缓冲区
    int bufferSize = response.length() * 2;  // 预留足够空间
    if (bufferSize < 8192) bufferSize = 8192;  // 最小8KB
    if (bufferSize > 32768) bufferSize = 32768;  // 最大32KB
    
    DynamicJsonDocument jsonDoc(bufferSize);
    DeserializationError error = deserializeJson(jsonDoc, response);

    if (!error) {
      outputText = jsonDoc["choices"][0]["message"]["content"].as<String>();
    } else {
      Serial.print("JSON解析错误: ");
      Serial.println(error.c_str());
      Serial.println("响应内容前100字符: " + response.substring(0, 100));
    }
  } else if (httpCode == -3) {
    Serial.println("错误：HTTP连接超时或请求体过大");
    Serial.println("建议：1. 检查网络连接 2. 尝试压缩图片 3. 使用更小的图片");
    outputText = "<timeout_error>";
  } else {
    Serial.printf("HTTP错误代码: %d", httpCode);
    if (httpCode > 0) {
      String errorResponse = http.getString();
      Serial.println("错误响应: " + errorResponse);
    }
  }

  http.end();
  return outputText;
}

// 图片大小检查和建议函数
void checkImageSize(String base64Image) {
  int imageSize = base64Image.length();
  Serial.println("=== 图片大小检查 ===");
  Serial.println("Base64图片大小: " + String(imageSize) + " 字符");
  
  // 估算原始图片大小（base64编码会增加约33%的大小）
  int originalSize = (imageSize * 3) / 4;
  Serial.println("估算原始图片大小: " + String(originalSize) + " 字节");
  
  if (imageSize > 200000) {  // 约200KB的base64
    Serial.println("⚠️  图片过大！建议：");
    Serial.println("1. 压缩图片到更小的尺寸");
    Serial.println("2. 降低图片质量");
    Serial.println("3. 转换为JPEG格式");
    Serial.println("4. 建议图片大小不超过150KB");
  } else if (imageSize > 100000) {  // 约100KB的base64
    Serial.println("⚠️  图片较大，处理可能需要更长时间");
  } else {
    Serial.println("✅ 图片大小合适");
  }
  Serial.println("==================");
}

// 主程序开始
void setup() {
  k10.begin();
  k10.initScreen();
  Serial.begin(9600);
  myIot.wifiConnect("dfrobotGuest", "dfrobot2020");
  while (!myIot.wifiStatus()) {
    Serial.println(".");
    delay(1000);
  }
  Serial.println(myIot.getWiFiLocalIP());

  // 检查本地base64图片是否已设置
  if (localBase64Image.length() > 0) {
    Serial.println("使用本地base64图片进行分析");
    checkImageSize(localBase64Image);  // 添加图片大小检查
    
    // 测试不同大小的图片
    Serial.println("\n=== 开始测试图片分析 ===");
    String answer = getGPTAnswer_base64img("图片里有什么", imageFormat, localBase64Image);
    Serial.println("回答: " + answer);
    Serial.println("=== 测试完成 ===\n");
  } else {
    Serial.println("本地base64图片未设置，请先赋值localBase64Image变量");
  }
}

void loop() {

}
